##################################################################
####      radios.nas - ePilot                                 ####
####                                                          ####
####    Com/Nav/XPDR/ADF/Tacan functions                      ####
####                                                          ####
##################################################################


var xpdr = func {

        var xpdrmode = getprop ("/instrumentation/transponder/modeset");
        if (xpdrmode == 'OFF') {
        setprop("/instrumentation/transponder/inputs/mode",0);
        setprop("/instrumentation/transponder/inputs/knob-mode",0);
        } else if (xpdrmode == 'STBY') {
        setprop("/instrumentation/transponder/inputs/mode",1);
        setprop("/instrumentation/transponder/inputs/knob-mode",1);
        } else if (xpdrmode == 'ON') {
        setprop("/instrumentation/transponder/inputs/mode",4);
        setprop("/instrumentation/transponder/inputs/knob-mode",4);
        } else if (xpdrmode == 'ALT') {
        setprop("/instrumentation/transponder/inputs/mode",5);
        setprop("/instrumentation/transponder/inputs/knob-mode",5);
        } else {
        setprop("/instrumentation/transponder/inputs/mode",0);
        setprop("/instrumentation/transponder/inputs/knob-mode",0);
        }
}

var com1power = func {
      var switchpos= getprop ("/instrumentation/comm[0]/func-knob");
      if (switchpos == 0) {
        setprop("/instrumentation/comm[0]/power-btn",0);
      } else {
        setprop("/instrumentation/comm[0]/power-btn",1);
      }
}

var com2power = func {
      var switchpos= getprop ("/instrumentation/comm[1]/func-knob");
      if (switchpos == 0) {
        setprop("/instrumentation/comm[1]/power-btn",0);
      } else {
        setprop("/instrumentation/comm[1]/power-btn",1);
      }
}

var nav1power = func {
      var switchpos= getprop ("/instrumentation/nav[0]/func-knob");
      if (switchpos == 0) {
        setprop("/instrumentation/nav[0]/power-btn",0);
      } else {
        setprop("/instrumentation/nav[0]/power-btn",1);
      }
}

var nav2power = func {
      var switchpos= getprop ("/instrumentation/nav[1]/func-knob");
      if (switchpos == 0) {
        setprop("/instrumentation/nav[1]/power-btn",0);
      } else {
        setprop("/instrumentation/nav[1]/power-btn",1);
      }
}

var adf1power = func {
      var switchpos= getprop ("/instrumentation/adf[0]/func-knob");
      if (switchpos == 0) {
        setprop("/instrumentation/adf[0]/power-btn",0);
      } else {
        setprop("/instrumentation/adf[0]/power-btn",1);
      }
}

var tacanxypos = func {
      var switchpos= getprop ("/instrumentation/tacan/xypos");
      if (switchpos == 0) {
        setprop("/instrumentation/tacan/frequencies/selected-channel[4]", "X");
      } else {
        setprop("/instrumentation/tacan/frequencies/selected-channel[4]", "Y");
      }
}

setlistener("/instrumentation/transponder/modeset", xpdr, 1, 0);
setlistener("/instrumentation/nav[0]/func-knob", nav1power, 1, 0);
setlistener("/instrumentation/nav[1]/func-knob", nav2power, 1, 0);
setlistener("/instrumentation/comm[0]/func-knob", com1power, 1, 0);
setlistener("/instrumentation/comm[1]/func-knob", com2power, 1, 0);
setlistener("/instrumentation/adf[0]/func-knob", adf1power, 1, 0);
setlistener("/instrumentation/tacan/xypos", tacanxypos, 1, 0);
