##########################################
##	Glaser-Dirks DG-1000S				##
##########################################

##	Liveries	##
aircraft.livery.init("Aircraft/DG-1000/Models/Liveries");

##	Instruments	##
# Load vario instrument for the mechanical vario-5stv5
# (the following code is based on the ILEC SC7 e-vario)
io.include("Aircraft/Generic/soaring-instrumentation-sdk.nas");

var probe = TotalEnergyProbe.new();

var vario_needle = Dampener.new(
	input: probe,
	dampening: 2.7,
	on_update: update_prop("/instrumentation/variometer/te-reading-mps"));

# Wrap everything together into an instrument
var fast_instruments = UpdateLoop.new(
	update_period: 0,
	components: [probe, vario_needle],
	enable: 1);

# Vibrating yaw string
var yawstring = YawString.new(
	on_update: update_prop("instrumentation/yawstring"));

var string_instrument = Instrument.new(
	components: [yawstring],
	enable: 1);

##	Tail ballast LED	##
# max. 12 kg (= 26.455 lbs) at 10 weights
# 1.2 kg ( = 2.6455 lbs ) per (light) weight, heavy weight = 2 light weights
var tail_ballast = props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[5]", 1);
var last_tail_ballast = 0.0;

var tail_ballast_led = func {
	var tbl = tail_ballast.getDoubleValue();
	if( tbl < 0.1 ){
		ballast_led.switch( 0 );
	}else{
		var n_blinks = math.round( tbl / 2.6455 );
		var pattern = [];
		for( var i = 0; i < n_blinks; i += 1 ){
			append( pattern, 0.2 );
			if( i < (n_blinks - 1) ){
				append( pattern, 0.2 );
			}
		}
		append( pattern, 2.5 );
		ballast_led.pattern = pattern;
		ballast_led.switch(1);
	}
}

var ballast_led = aircraft.light.new("instrumentation/indicators/tail-ballast-led", [0.05, 0.05] );

var check_ballast = maketimer( 0.5, func{
	if( tail_ballast.getDoubleValue() != last_tail_ballast ){
		last_tail_ballast = tail_ballast.getDoubleValue();
		tail_ballast_led();
	}
});
check_ballast.simulatedTime = 1;


##	Water Ballast	##
var wing_outflow_rate = [
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/wing-outflow-rate-pps[0]"),
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/wing-outflow-rate-pps[1]"),
];
var tank_level_p = [
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[3]"),
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[4]"),
];
var tank_level_lbs = [ 0.0, 0.0 ];
var delta_time = props.globals.getNode("/sim/time/delta-sec");

var update_waterballast = func () {
	var dt = delta_time.getDoubleValue();
	for( var i=0; i<=1; i=i+1 ){
		tank_level_lbs[ i ] = tank_level_p[ i ].getDoubleValue();
		tank_level_p[ i ].setDoubleValue( math.max( tank_level_lbs[ i ] - wing_outflow_rate[ i ].getDoubleValue()  * dt, 0.0 ) );
	}
}
var waterballast_timer = maketimer( 0.0, update_waterballast );
waterballast_timer.simulatedTime = 1;


##	Start updates when FDM is initialized	##
var ls = setlistener("/sim/signals/fdm-initialized", func() {
#	waterballast_timer.start();
	check_ballast.start();
	removelistener( ls );
});
