##############################################################################
var AircraftBanner = {};
AircraftBanner.new = func {
	var obj = {};
	obj.parents = [AircraftBanner];
	obj.onHookNode = props.globals.getNode( "sim/model/banner-on-hook", 1 );
	obj.speedbrakeNode = props.globals.getNode( "controls/flight/speedbrake" );
	
	obj.releaseNode = props.globals.getNode( "controls/banner-release", 1 );
	
	obj.timer_loop = maketimer( 0.5, obj, obj.timer );
	obj.timer_loop.simulatedTime = 1;
	obj.timer_loop.start();
	return obj;
}

AircraftBanner.timer = func {
	if( me.releaseNode.getValue() != 0 and me.onHookNode.getValue() == 1 ) {
		print( "banner-release" );
		me.onHookNode.setBoolValue( 0 );
		me.releaseNode.setBoolValue( 0 );
		me.speedbrakeNode.setBoolValue( 0 );
	}
}

AircraftBanner.hook = func {
	print( "banner-pickup" );
	me.onHookNode.setBoolValue( 1 );
	me.speedbrakeNode.setBoolValue( 1 );
}

##############################################################################
var GroundBanner = {};
GroundBanner.new = func( model_node ) {
	var obj = {};
	obj.parents = [GroundBanner];
	obj.modelNode = model_node;
	obj.hooked = 0;
	print( "GroundBanner created" );
	return obj;
}

GroundBanner.hook = func {
	me.hooked = 1; 
}


##############################################################################
var BannerMgr = {};
BannerMgr.new = func( aircraft_banner ) {
	var obj = {};
	obj.parents = [BannerMgr];
	
	obj.aircraftBanner = aircraft_banner;
	obj.banners = [];
	
	obj.hookDistance = 1e-9;
	
	obj.lonNode = props.globals.getNode("/position/longitude-deg", 1);
	obj.latNode = props.globals.getNode("/position/latitude-deg", 1);
	obj.altNode = props.globals.getNode( "/position/altitude-agl-ft", 1 );

	obj.interval = 2.0;

	obj.timer_loop = maketimer( 2.0, obj, obj.timer );
	obj.timer_loop.simulatedTime = 1;
	
	obj.timer();
	obj.timer_loop.start();
	return obj;
}

BannerMgr.addBanner = func( path, lat, lon, heading ) {
	var elev_m = geo.elevation(lat, lon);
	if( elev_m == nil ) {
		print("can't get elevation for " ~ lat ~ "/" ~ lon ~ " - groundbanner ignored" );
		return;
	}
	var banner = GroundBanner.new( geo.put_model( path, lat, lon, elev_m, heading ) );
	append( me.banners, banner );
}

# periodically check the position of the aircraft relative to the configured groundbanners
#
BannerMgr.timer = func {
	
	var lon = me.lonNode.getValue();
	var lat = me.latNode.getValue();
	var alt = me.altNode.getValue();
	
	var minDist = 999;
	
	if( aircraftBanner.onHookNode.getValue() == 0 and alt < 15 ) {
		foreach( var banner; me.banners ) {
			if( banner.hooked == 0 ) {
				var dlat = banner.modelNode.getNode( "latitude-deg" ).getValue() - lat;
				var dlon = banner.modelNode.getNode( "longitude-deg" ).getValue() - lon;
				var dist = dlat * dlat + dlon*dlon;
				if( dist < minDist ) {
					minDist = dist;
				}
				
				if( dist <= me.hookDistance ) {
					banner.hook();
					aircraftBanner.hook();
				}
			}
		}
	}
	
	# shorten interval when closing in
	var interval = 2.0;
	
	if( minDist < 1e-6 ) {
		interval = 1.0;
	}
	if( minDist < 1e-7 ) {
		interval = .5;
	}
	if( minDist < 1e-8 ) {
		interval = .1;
	}

	if( interval != me.interval ){
		me.timer_loop.restart( interval );
		me.interval = interval;
	}
}


##############################################################################
var bannerMgr = nil;
var aircraftBanner = nil;

var init_banner = func {
	aircraftBanner = AircraftBanner.new();
	bannerMgr = BannerMgr.new( aircraftBanner );
	fgcommand("loadxml", props.Node.new({
		"filename": getprop("/sim/fg-home") ~ "/" ~ "groundbanner.xml",
					    "targetnode": "/sim/groundbanners/",
	}));
	
	foreach( var bannerN; props.globals.getNode( "/sim/groundbanners", 1 ).getChildren( "groundbanner" ) ) {
		bannerMgr.addBanner( 
			bannerN.getNode( "path" ).getValue(),
			bannerN.getNode( "lat" ).getValue(),
			bannerN.getNode( "lon" ).getValue(),
			bannerN.getNode( "heading" ).getValue()
		);
	}
	
}

setlistener("/sim/signals/fdm-initialized", init_banner );

##############################################################################
var setBannerOnPosition = func {
	var bannerpos    = geo.aircraft_position().apply_course_distance( getprop("orientation/heading-deg")+90 , 50 );   
	bannerMgr.addBanner("Aircraft/Dragonfly/Models/Banner/GroundBanner.xml",bannerpos.lat(),bannerpos.lon(),getprop("/orientation/heading-deg"));
	setprop("/sim/messages/ground","Banner pickup has been placed 50m to your right");
}

##############################################################################
var BannerConfig = func {
	var cd       = getprop("sim/model/banner/cd-banner");
	var area_sqm = getprop("sim/model/banner/area-banner-sqm");
	
	var area_sqft = area_sqm * 10.7639;
	var CDxA_sqm  = cd * area_sqm;
	var CDxA_sqft = cd * area_sqft;
	
	setprop("sim/model/banner/CDxA-banner-sqm" , CDxA_sqm);
	setprop("sim/model/banner/CDxA-banner-sqft", CDxA_sqft);
	
}

##############################################################################
var setBannerDefaults = func {
	setprop("sim/model/banner/cd-banner", 0.01);
	setprop("sim/model/banner/area-banner-sqm", 17.);
}

