# Increment a property, constraining to min/max values, and using interpolate()
# with specified time period.
#
var incrementProp = func(name, delta, min, max, t) {
    value = getprop(name);
    
    # Ensure that we end up at a multiple of <delta> if we get called while
    # property is still moving from an earlier interpolation.
    #
    if (delta > 0)      value = delta * math.ceil(value / delta);
    else if (delta < 0) value = (-delta) * math.floor(value / (-delta));
    
    value += delta;
    if (value < min)    value = min;
    if (value > max)    value = max;
    interpolate(name, value, t);
}
# HARRIER controls
#  extra check to see if the harrier is carrying its AAR boom

var serviceable = props.globals.getNode ("systems/refuel/serviceable");

setlistener ("sim/weight[7]/selected", func (probe_mounted) {
   if (probe_mounted.getValue () != "none") {
      serviceable.setBoolValue (1);
      # hack: force the aar.nas code to rescan the list of remote aircraft, to detect any tanker.
      setprop ("ai/models/model-added", "Harrier-GR3 refueling probe");
   }
   else {
      serviceable.setBoolValue (0);
   }
}, 1, 0);
