# Maik Justus < fg # mjustus : de >, based on bo105.nas by Melchior FRANZ, < mfranz # aon : at >
#
# ========================================================================
# Updated for Mil Mi 12 : BARANGER Emmanuel 04/2023
# ========================================================================

if (!contains(globals, "cprint")) {
  globals.cprint = func {};
}

var optarg                  = aircraft.optarg;
var makeNode                = aircraft.makeNode;

var sin                     = func(a) { math.sin(a * math.pi / 180.0) }
var cos                     = func(a) { math.cos(a * math.pi / 180.0) }
var pow                     = func(v, w) { math.exp(math.ln(v) * w) }
var npow                    = func(v, w) { math.exp(math.ln(abs(v)) * w) * (v < 0 ? -1 : 1) }
var clamp                   = func(v, min = 0, max = 1) { v < min ? min : v > max ? max : v }
var normatan                = func(x) { math.atan2(x, 1) * 2 / math.pi }

# timers =================================================================
var turbine_timer           = aircraft.timer.new("/sim/time/hobbs/turbines", 10);
aircraft.timer.new("/sim/time/hobbs/helicopter", nil).start();

# ========================================================================
# engines/rotor LEFT =====================================================
# ========================================================================
var state0                  = props.globals.getNode("sim/model/mi12[0]/state");
var engine0                 = props.globals.getNode("sim/model/mi12[0]/engine");
var turbine0                = props.globals.getNode("sim/model/mi12[0]/turbine-rpm-pct", 1);
var torque_pct0             = props.globals.getNode("sim/model/mi12[0]/torque-pct", 1);

var rotor0                  = props.globals.getNode("controls/engines/engine[0]/magnetos");
var collective0             = props.globals.getNode("controls/engines/engine[0]/throttle");

var target_rel_rpm0         = props.globals.getNode("controls/rotor[0]/reltarget", 1);
var max_rel_torque0         = props.globals.getNode("controls/rotor[0]/maxreltorque", 1);

var rotor_rpm0              = props.globals.getNode("rotors/mainL/rpm");
var stall0                  = props.globals.getNode("rotors/mainL/stall", 1);
var stall_filtered0         = props.globals.getNode("rotors/mainL/stall-filtered", 1);
var stall_filtered02        = props.globals.getNode("rotors/mainL/stall-filtered2", 1);
var cone0                   = props.globals.getNode("rotors/mainL/cone-deg", 1);
var cone01                  = props.globals.getNode("rotors/mainL/cone1-deg", 1);
var cone02                  = props.globals.getNode("rotors/mainL/cone2-deg", 1);
var cone03                  = props.globals.getNode("rotors/mainL/cone3-deg", 1);
var cone04                  = props.globals.getNode("rotors/mainL/cone4-deg", 1);

var torque_sound_filtered0  = props.globals.getNode("rotors/gear[0]/torque-sound-filtered", 1);
var torque_sound_filtered02 = props.globals.getNode("rotors/gear[0]/torque-sound-filtered2", 1);
# ========================================================================
# engines/rotor RIGHT ====================================================
# ========================================================================
var state1                  = props.globals.getNode("sim/model/mi12[1]/state");
var engine1                 = props.globals.getNode("sim/model/mi12[1]/engine");
var turbine1                = props.globals.getNode("sim/model/mi12[1]/turbine-rpm-pct", 1);
var torque_pct1             = props.globals.getNode("sim/model/mi12[1]/torque-pct", 1);

var rotor1                  = props.globals.getNode("controls/engines/engine[1]/magnetos");
var collective1             = props.globals.getNode("controls/engines/engine[1]/throttle");

var target_rel_rpm1         = props.globals.getNode("controls/rotor[1]/reltarget", 1);
var max_rel_torque1         = props.globals.getNode("controls/rotor[1]/maxreltorque", 1);

var rotor_rpm1              = props.globals.getNode("rotors/mainR/rpm");
var stall1                  = props.globals.getNode("rotors/mainR/stall", 1);
var stall_filtered1         = props.globals.getNode("rotors/mainR/stall-filtered", 1);
var stall_filtered12        = props.globals.getNode("rotors/mainR/stall-filtered2", 1);
var cone1                   = props.globals.getNode("rotors/mainR/cone-deg", 1);
var cone11                  = props.globals.getNode("rotors/mainR/cone1-deg", 1);
var cone12                  = props.globals.getNode("rotors/mainR/cone2-deg", 1);
var cone13                  = props.globals.getNode("rotors/mainR/cone3-deg", 1);
var cone14                  = props.globals.getNode("rotors/mainR/cone4-deg", 1);

var torque_sound_filtered1  = props.globals.getNode("rotors/gear[1]/torque-sound-filtered", 1);
var torque_sound_filtered12 = props.globals.getNode("rotors/gear[1]/torque-sound-filtered2", 1);
# ========================================================================
var torque                  = props.globals.getNode("rotors/total-torque", 1);

# state:
# 0 off
# 1 engine startup
# 2 engine startup with small torque on rotor
# 3 engine idle
# 4 engine accel
# 5 engine sound loop

var update_state0 = func {
  var s = state0.getValue();
  var new_state0 = arg[0];
  if (new_state0 == (s+1)) {
    state0.setValue(new_state0);
    if (new_state0 == (1)) {
      settimer(func { update_state0(2) }, 1.5);
      interpolate(engine0, 0.03, 0.1, 0.002, 0.3, 0.02, 0.1, 0.003, 0.7, 0.03, 0.1, 0.01, 0.7);
    } else {
      if (new_state0 == (2)) {
        settimer(func { update_state0(3) }, 1);
        rotor0.setValue(1);
        max_rel_torque0.setValue(0.01);
        target_rel_rpm0.setValue(0.002);
        interpolate(engine0, 0.05, 0.2, 0.03, 1, 0.07, 0.1, 0.04, 0.9, 0.02, 0.5);
      } else {
        if (new_state0 == (3)) {
          if (rotor_rpm0.getValue() > 100) {
            #rotor is running at high rpm, so accel. engine faster
            max_rel_torque0.setValue(1);
            target_rel_rpm0.setValue(1.03);
            state0.setValue(5);
            interpolate(engine0, 1.03, 10);
          } else {
            settimer(func { update_state0(4) }, 1.5);
            max_rel_torque0.setValue(0.05);
            target_rel_rpm0.setValue(0.02);
            interpolate(engine0, 0.07, 0.1, 0.03, 0.25, 0.075, 0.2, 0.08, 1, 0.06,2);
          }
        } else {
          if (new_state0 == (4)) {
            settimer(func { update_state0(5) }, 30);
            max_rel_torque0.setValue(0.25);
            target_rel_rpm0.setValue(0.8);
          } else {
              if (new_state0 == (5)) {
              max_rel_torque0.setValue(1);
              target_rel_rpm0.setValue(1.03);
            }
          }
        }
      }
    }
  }
}

var update_state1 = func {
  var s = state1.getValue();
  var new_state1 = arg[0];
  if (new_state1 == (s+1)) {
    state1.setValue(new_state1);
    if (new_state1 == (1)) {
      settimer(func { update_state1(2) }, 1.5);
      interpolate(engine1, 0.03, 0.1, 0.002, 0.3, 0.02, 0.1, 0.003, 0.7, 0.03, 0.1, 0.01, 0.7);
    } else {
      if (new_state1 == (2)) {
        settimer(func { update_state1(3) }, 1);
        rotor1.setValue(1);
        max_rel_torque1.setValue(0.01);
        target_rel_rpm1.setValue(0.002);
        interpolate(engine1, 0.05, 0.2, 0.03, 1, 0.07, 0.1, 0.04, 0.9, 0.02, 0.5);
      } else {
        if (new_state1 == (3)) {
          if (rotor_rpm1.getValue() > 100) {
            #rotor is running at high rpm, so accel. engine faster
            max_rel_torque1.setValue(1);
            target_rel_rpm1.setValue(1.03);
            state1.setValue(5);
            interpolate(engine1, 1.03, 10);
          } else {
            settimer(func { update_state1(4) }, 1.5);
            max_rel_torque1.setValue(0.05);
            target_rel_rpm1.setValue(0.02);
            interpolate(engine1, 0.07, 0.1, 0.03, 0.25, 0.075, 0.2, 0.08, 1, 0.06,2);
          }
        } else {
          if (new_state1 == (4)) {
            settimer(func { update_state1(5) }, 30);
            max_rel_torque1.setValue(0.25);
            target_rel_rpm1.setValue(0.8);
          } else {
              if (new_state1 == (5)) {
              max_rel_torque1.setValue(1);
              target_rel_rpm1.setValue(1.03);
            }
          }
        }
      }
    }
  }
}

var engines = func {
  if (props.globals.getNode("sim/crashed",1).getBoolValue()) {
    return;
  }

  var s0 = state0.getValue();
  if (arg[0] == 1) {
    if (s0 == 0) {
      setprop("sim/model/mi12[0]/shutdown",0);
      setprop("controls/lighting/instruments-norm",0.8);
      update_state0(1);
    }
  } else {
    setprop("sim/model/mi12[0]/shutdown",1);
    setprop("controls/lighting/instruments-norm",0);
    rotor0.setValue(0);        # engines stopped
    state0.setValue(0);
    interpolate(engine0, 0, 4);
  }

  var s1 = state1.getValue();
  if (arg[0] == 1) {
    if (s1 == 0) {
      setprop("sim/model/mi12[1]/shutdown",0);
      setprop("controls/lighting/instruments-norm",0.8);
      update_state1(1);
    }
  } else {
    setprop("sim/model/mi12[1]/shutdown",1);
    setprop("controls/lighting/instruments-norm",0);
    rotor1.setValue(0);        # engines stopped
    state1.setValue(0);
    interpolate(engine1, 0, 4);
  }
}

var update_engine = func {
  if (state0.getValue() > 3 ) {
    interpolate (engine0,  clamp( rotor_rpm0.getValue() / 235 , 0.05, target_rel_rpm0.getValue() ), 0.25 );
  }
  if (state1.getValue() > 3 ) {
    interpolate (engine1,  clamp( rotor_rpm1.getValue() / 235 , 0.05, target_rel_rpm1.getValue() ), 0.25 );
  }
}

var update_rotor_cone_angle0 = func {
  var r0 = rotor_rpm0.getValue();
  var f0 = 1 - r0 / 100;
  f0 = clamp (f0, 0.1 , 1);
  c0 = cone0.getValue();
  cone01.setDoubleValue( f0 *c0 *0.40 + (1-f0) * c0 );
  cone02.setDoubleValue( f0 *c0 *0.35);
  cone03.setDoubleValue( f0 *c0 *0.3);
  cone04.setDoubleValue( f0 *c0 *0.25);
}

var update_rotor_cone_angle1 = func {
  var r1 = rotor_rpm1.getValue();
  var f1 = 1 - r1 / 100;
  f1 = clamp (f1, 0.1 , 1);
  c1 = cone1.getValue();
  cone11.setDoubleValue( f1 *c1 *0.40 + (1-f1) * c1 );
  cone12.setDoubleValue( f1 *c1 *0.35);
  cone13.setDoubleValue( f1 *c1 *0.3);
  cone14.setDoubleValue( f1 *c1 *0.25);
}

# torquemeter
var torque_val = 0;
torque.setDoubleValue(0);

var update_torque = func(dt) {
  var f = dt / (0.2 + dt);
  torque_val = torque.getValue() * f + torque_val * (1 - f);
  torque_pct0.setDoubleValue(torque_val / 5300);
  torque_pct1.setDoubleValue(torque_val / 5300);
}

# sound =============================================================
#
# stall sound
var stall0_val = 0;
stall0.setDoubleValue(0);

var update_stall_and_torque_sound0 = func(dt) {
  var s = stall0.getValue();
  if (s < stall0_val) {
    var f = dt / (0.3 + dt);
    stall0_val = s * f + stall0_val * (1 - f);
  } else {
    stall0_val = s;
  }
  var c = collective0.getValue();
  stall_filtered0.setDoubleValue(stall0_val + 0.006 * (1 - c));
  stall_filtered02.setDoubleValue(stall0_val*10 + 0.006 * ((1 - c-0.5)>0?(1 - c-0.5):0));

  var t = torque.getValue();
  t = clamp(t * 0.000001);
  t = t*0.25 + 0.75;
  var r = clamp(rotor_rpm0.getValue()*0.02-1);
  torque_sound_filtered0.setDoubleValue(t*r);

  var f = 0.3;
  torque_sound_filtered02.setDoubleValue(f*t*r+(1-f)*(stall0_val + 0.006 * (1 - c)));
}

var stall1_val = 0;
stall1.setDoubleValue(0);

var update_stall_and_torque_sound1 = func(dt) {
  var s = stall1.getValue();
  if (s < stall1_val) {
    var f = dt / (0.3 + dt);
    stall1_val = s * f + stall1_val * (1 - f);
  } else {
    stall1_val = s;
  }
  var c = collective1.getValue();
  stall_filtered1.setDoubleValue(stall1_val + 0.006 * (1 - c));
  stall_filtered12.setDoubleValue(stall1_val*10 + 0.006 * ((1 - c-0.5)>0?(1 - c-0.5):0));

  var t = torque.getValue();
  t = clamp(t * 0.000001);
  t = t*0.25 + 0.75;
  var r = clamp(rotor_rpm1.getValue()*0.02-1);
  torque_sound_filtered1.setDoubleValue(t*r);

  var f = 0.3;
  torque_sound_filtered12.setDoubleValue(f*t*r+(1-f)*(stall1_val + 0.006 * (1 - c)));
}

# skid slide sound
var Skid = {
  new : func(n) {
    var m = { parents : [Skid] };
    var soundN = props.globals.getNode("sim/sound", 1).getChild("slide", n, 1);
    var gearN = props.globals.getNode("gear", 1).getChild("gear", n, 1);

    m.compressionN = gearN.getNode("compression-norm", 1);
    m.rollspeedN = gearN.getNode("rollspeed-ms", 1);
    m.frictionN = gearN.getNode("ground-friction-factor", 1);
    m.wowN = gearN.getNode("wow", 1);
    m.volumeN = soundN.getNode("volume", 1);
    m.pitchN = soundN.getNode("pitch", 1);

    m.compressionN.setDoubleValue(0);
    m.rollspeedN.setDoubleValue(0);
    m.frictionN.setDoubleValue(0);
    m.volumeN.setDoubleValue(0);
    m.pitchN.setDoubleValue(0);
    m.wowN.setBoolValue(1);
    m.self = n;
    return m;
  },
  update : func {
    me.wowN.getBoolValue() or return;
    var rollspeed = abs(me.rollspeedN.getValue());
    me.pitchN.setDoubleValue(rollspeed * 0.6);

    var s = normatan(20 * rollspeed);
    var f = clamp((me.frictionN.getValue() - 0.5) * 2);
    var c = clamp(me.compressionN.getValue() * 2);
    me.volumeN.setDoubleValue(s * f * c * 2);
    #if (!me.self) {
    # cprint("33;1", sprintf("S=%0.3f  F=%0.3f  C=%0.3f  >>  %0.3f", s, f, c, s * f * c));
    #}
  },
};

var skid = [];
for (var i = 0; i < 3; i += 1) {
  append(skid, Skid.new(i));
}

var update_slide = func {
  forindex (var i; skid) {
    skid[i].update();
  }
}

# crash handler =====================================================
#var load = nil;
var crash = func {
  if (arg[0]) {
    # crash
    setprop("rotors/mainL/rpm", 0);
    setprop("rotors/mainL/blade[0]/flap-deg", -60);
    setprop("rotors/mainL/blade[1]/flap-deg", -50);
    setprop("rotors/mainL/blade[2]/flap-deg", -40);
    setprop("rotors/mainL/blade[3]/flap-deg", -30);
    setprop("rotors/mainL/blade[0]/incidence-deg", -30);
    setprop("rotors/mainL/blade[1]/incidence-deg", -20);
    setprop("rotors/mainL/blade[2]/incidence-deg", -50);
    setprop("rotors/mainL/blade[3]/incidence-deg", -55);

    setprop("rotors/mainR/rpm", 0);
    setprop("rotors/mainR/blade[0]/flap-deg", -60);
    setprop("rotors/mainR/blade[1]/flap-deg", -50);
    setprop("rotors/mainR/blade[2]/flap-deg", -40);
    setprop("rotors/mainR/blade[3]/flap-deg", -30);
    setprop("rotors/mainR/blade[0]/incidence-deg", -30);
    setprop("rotors/mainR/blade[1]/incidence-deg", -20);
    setprop("rotors/mainR/blade[2]/incidence-deg", -50);
    setprop("rotors/mainR/blade[3]/incidence-deg", -55);

    rotor0.setValue(0);
    torque_pct0.setValue(torque_val = 0);
    stall_filtered0.setValue(stall_val = 0);
    state0.setValue(0);

    rotor1.setValue(0);
    torque_pct1.setValue(torque_val = 0);
    stall_filtered1.setValue(stall_val = 0);
    state1.setValue(0);

  } else {
    # uncrash (for replay)
    setprop("rotors/mainL/rpm", 1500);
    setprop("rotors/mainR/rpm", 1500);
    for (i = 0; i < 4; i += 1) {
      setprop("rotors/mainL/blade[" ~ i ~ "]/flap-deg", 0);
      setprop("rotors/mainL/blade[" ~ i ~ "]/incidence-deg", 0);

      setprop("rotors/mainR/blade[" ~ i ~ "]/flap-deg", 0);
      setprop("rotors/mainR/blade[" ~ i ~ "]/incidence-deg", 0);
    }
    rotor0.setValue(1);
    rotor1.setValue(1);
    state0.setValue(5);
    state1.setValue(5);
  }
}

# "manual" rotor animation for flight data recorder replay ============
var rotor_step0 = props.globals.getNode("sim/model/mi12[0]/rotor-step-deg");
var blade1_pos0 = props.globals.getNode("rotors/mainL/blade[0]/position-deg", 1);
var blade2_pos0 = props.globals.getNode("rotors/mainL/blade[1]/position-deg", 1);
var blade3_pos0 = props.globals.getNode("rotors/mainL/blade[2]/position-deg", 1);
var blade4_pos0 = props.globals.getNode("rotors/mainL/blade[3]/position-deg", 1);
var rotorangle0 = 0;

var rotoranim0_loop = func {
  var i0 = rotor_step0.getValue();
  if (i0 >= 0.0) {
    blade1_pos0.setValue(rotorangle0);
    blade2_pos0.setValue(rotorangle0 + 90);
    blade3_pos0.setValue(rotorangle0 + 180);
    blade4_pos0.setValue(rotorangle0 + 270);
    rotorangle0 += i0;
    settimer(rotoranim0_loop, 0.1);
  }
}

var rotor_step1 = props.globals.getNode("sim/model/mi12[1]/rotor-step-deg");
var blade1_pos1 = props.globals.getNode("rotors/mainR/blade[0]/position-deg", 1);
var blade2_pos1 = props.globals.getNode("rotors/mainR/blade[1]/position-deg", 1);
var blade3_pos1 = props.globals.getNode("rotors/mainR/blade[2]/position-deg", 1);
var blade4_pos1 = props.globals.getNode("rotors/mainR/blade[3]/position-deg", 1);
var rotorangle1 = 0;

var rotoranim1_loop = func {
  var i1 = rotor_step1.getValue();
  if (i1 >= 0.0) {
    blade1_pos1.setValue(rotorangle1);
    blade2_pos1.setValue(rotorangle1 + 90);
    blade3_pos1.setValue(rotorangle1 + 180);
    blade4_pos1.setValue(rotorangle1 + 270);
    rotorangle1 += i1;
    settimer(rotoranim1_loop, 0.1);
  }
}

var init_rotoranim = func {
  if (rotor_step0.getValue() >= 0.0) {
    settimer(rotoranim0_loop, 0.1);
  }
  if (rotor_step1.getValue() >= 0.0) {
    settimer(rotoranim1_loop, 0.1);
  }
}

# view management ===================================================
#
var elapsedN = props.globals.getNode("/sim/time/elapsed-sec", 1);
var flap_mode = 0;
var down_time = 0;
controls.flapsDown = func(v) {
  if (!flap_mode) {
    if (v < 0) {
      down_time = elapsedN.getValue();
      flap_mode = 1;
      dynamic_view.lookat(
           5,   # heading left
         -20,   # pitch up
           0,   # roll right
         0.2,   # right
         0.6,   # up
        0.85,   # back
         0.2,   # time
          55,   # field of view
      );
    } elsif (v > 0) {
      flap_mode = 2;
      var p = "/sim/view/dynamic/enabled";
      setprop(p, !getprop(p));
    }
  } else {
    if (flap_mode == 1) {
      if (elapsedN.getValue() < down_time + 0.2) {
        return;
      }
      dynamic_view.resume();
    }
    flap_mode = 0;
  }
}

# register function that may set me.heading_offset, me.pitch_offset, me.roll_offset,
# me.x_offset, me.y_offset, me.z_offset, and me.fov_offset
#
dynamic_view.register(func {
  var lowspeed = 1 - normatan(me.speedN.getValue() / 50);
  var r = sin(me.roll) * cos(me.pitch);

  me.heading_offset = (me.roll < 0 ? -50 : -30) * r * abs(r);                                                  # heading change due to roll left/right


  me.pitch_offset = (me.pitch < 0 ? -50 : -50) * sin(me.pitch) * lowspeed + 15 * sin(me.roll) * sin(me.roll);  # pitch change due to pitch down/up

  me.roll_offset = -15 * r * lowspeed;                                                                         # roll change due to roll
});

# main() ============================================================
var delta_time = props.globals.getNode("/sim/time/delta-realtime-sec", 1);
var adf_rotation = props.globals.getNode("/instrumentation/adf/rotation-deg", 1);
var hi_heading = props.globals.getNode("/instrumentation/heading-indicator/indicated-heading-deg", 1);

var main_loop = func {
  # adf_rotation.setDoubleValue(hi_heading.getValue());

  var dt = delta_time.getValue();
  update_torque(dt);
  update_stall_and_torque_sound0(dt);
  update_stall_and_torque_sound1(dt);
  update_slide();
  update_engine();
  update_rotor_cone_angle0();
  update_rotor_cone_angle1();
  settimer(main_loop, 0);
}

var crashed = 0;
var variant = nil;
var doors = nil;
var config_dialog = nil;

# initialization
setlistener("/sim/signals/fdm-initialized", func {

  init_rotoranim();
  collective0.setDoubleValue(1);
  collective1.setDoubleValue(1);

  setlistener("/sim/signals/reinit", func {
    cmdarg().getBoolValue() and return;
    cprint("32;1", "reinit");
    turbine_timer.stop();
    collective0.setDoubleValue(1);
    collective1.setDoubleValue(1);
    variant.scan();
    crashed = 0;
  });

  setlistener("sim/crashed", func {
    cprint("31;1", "crashed ", cmdarg().getValue());
    turbine_timer.stop();
    if (cmdarg().getBoolValue()) {
      crash(crashed = 1);
    }
  });

  setlistener("/sim/freeze/replay-state", func {
    cprint("33;1", cmdarg().getValue() ? "replay" : "pause");
    if (crashed) {
      crash(!cmdarg().getBoolValue())
    }
  });

  # the attitude indicator needs pressure
  # settimer(func { setprop("engines/engine/rpm", 3000) }, 8);

  main_loop();
});
