var hdg = props.globals.getNode("orientation/heading-magnetic-deg");
var hdgBug = props.globals.getNode("autopilot/settings/heading-bug-deg");
var lon = props.globals.getNode("position/longitude-deg");
var lat = props.globals.getNode("position/latitude-deg");
var index = 0;

var instrument_path = "Aircraft/Phoenix/Models/Instruments/Zeus/";

var zeus_controller = {
	parents: [canvas.Map.Controller],

	new: func(map) {
		var m = { parents: [zeus_controller],
			map: map,
			};
		m.index = index;

		return m;
	}
};

var canvas_nd = {
	new: func(canvasGroup)
	{
		var m = { parents: [canvas_nd] };
		m.group = canvasGroup;
		m.map = canvasGroup.createChild('map');
		m.index = index;

		var font_mapper = func(family, weight) {
			if ( weight == "bold" ) {
				return "LiberationFonts/LiberationSans-Bold.ttf";
			} else {
				return "LiberationFonts/LiberationSans-Regular.ttf";
			}
		};

		canvas.parsesvg(canvasGroup, instrument_path~"zeus_main.svg", {'font-mapper': font_mapper});

		var svg_keys = ["ac_symbol", "range.1", "range.2", "range.3", "range.4", "range.5", "range.6", "range.7",
		"tas.digits", "gs.digits", "asi.digits", "asi.tape",
		"brg.text", "trk.text", "vnetto.text", "gs.text", "th_gain.text", "th_avg.text", "agl.text", "arr_alt.text",
		"vario.pointer", "vario.digits", "wind_spd.digits", "wind_hdg.digits", "wind_hdg.needle"];
		foreach(var key; svg_keys) {
			m[key] = canvasGroup.getElementById(key);
			var clip_el = canvasGroup.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)",
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				m[key].set("clip", clip_rect);
				m[key].set("clip-frame", canvas.Element.PARENT);
			}
		}

		### NavDisplay ###
		m.map.setRange( 25 * 300 / 520 );
		m.on_range_change();
		m.map.setTranslation(240,374); # AC center
		m.map.setPos(lat.getValue(),lon.getValue(), 0.0);
		var r = func(name,vis=1,zindex=nil) return caller(0)[0];
		m.map.setController(zeus_controller);

		foreach(var type; [ r('STAMEN') ])
				m.map.addLayer(factory: canvas.OverlayLayer, type_arg: type.name,visible: type.vis, priority: type.zindex,);

		foreach(var type; [r('TFC'),r('APT') ] )
				m.map.addLayer(factory: canvas.SymbolLayer, type_arg: type.name, visible: type.vis, priority: type.zindex,);

		index+=1;

		m.timer = maketimer(0.2, m, m.update);
		return m;
	},
	update: func()
	{
		var ias_kph = ias_kt.getDoubleValue() * KT2MPS * 3.6;
		me["asi.tape"].setTranslation( 0, ias_kph * 1.4016 );
		me["asi.digits"].setText( sprintf("%3d", math.round( ias_kph ) ) );
		me["tas.digits"].setText( sprintf("%3d", math.round( tas_kt.getDoubleValue() * KT2MPS * 3.6 ) ) );
		me["gs.digits"].setText(  sprintf("%3d", math.round( gs_kt.getDoubleValue()  * KT2MPS * 3.6 ) ) );

		me["trk.text"].setText( sprintf("%3d", math.round( hdg_trk.getDoubleValue() ) ) ~"°" );

		var vario_current = vario_te.getDoubleValue();
		me["vario.pointer"].setTranslation( 0, vario_current * 27.6 );
		me["vario.digits"].setText( sprintf("%2.1f", vario_current ) );
		# Calculate netto vario from total energy vario
		var x = tas_kt.getDoubleValue() * KT2MPS * 3.6;
		vario_nt = vario_current + ( ( polar_def[0] * math.pow( x, 2 ) + polar_def[1] * x + polar_def[0] ) / 3.6 );
		me["vnetto.text"].setText( sprintf("%2.1f", vario_nt ) );

		me["gs.text"].setText( sprintf("%3d", math.round( gs_kt.getDoubleValue()  * KT2MPS * 3.6 ) ) );
		me["agl.text"].setText( sprintf("%4d", math.round( alt_agl.getDoubleValue() * FT2M ) ) );


		# Wind indication
		var wind_heading = wind_deg.getDoubleValue();
		var ac_heading = hdg_true.getDoubleValue();
		me["wind_hdg.needle"].setRotation( ( ac_heading - wind_heading ) * D2R );
		me["wind_hdg.digits"].setText( sprintf("%3d", math.round( wind_heading ) ) ~ "°" );
		me["wind_spd.digits"].setText( sprintf("%3d", math.round( wind_kt.getDoubleValue() * KT2MPS * 3.6 ) ) );
		
		me.map.setPos(lat.getValue(), lon.getValue(), 0.0);
		me.map.setRotation( -hdg.getDoubleValue() * D2R, [ 240, 374 ] );
		me.map.update();
	},
	on_range_change: func {
		var rng = me.map.getRange() / 300 * 104;
		var ranges = [ rng, 2*rng, 3*rng, 4*rng, 5*rng, 6*rng, 7*rng ];
		forindex( var i; ranges ){
			if( ranges[i] < 1 ){
				me["range."~ (i + 1)].setText( sprintf("%2d", math.round( 1000 * ranges[i], 100 ) ) ~"m" );
			} elsif( ranges[i] < 10 ) {
				me["range."~ (i + 1)].setText( sprintf("%2.1f", ranges[i] ) ~"km" );
			} else {
				me["range."~ (i + 1)].setText( sprintf("%2d", ranges[i] ) ~"km" );
			}
		}
	},
	show: func()
	{
		me.update();
		me.timer.start();
		me.group.show();
	},
	hide: func()
	{
		me.timer.stop();
		me.group.hide();
	}
};
