#	Ref. POH, p.3-8ff.; p.7-22ff.; p.9-A1-11ff.
var annun_p = props.globals.initNode("/instrumentation/annunciator");
var annun_lights = {
	master_caution:		annun_p.initNode("master-caution", 0, "BOOL"),
	master_warning:		annun_p.initNode("master-warning", 0, "BOOL"),
	drive: [
		annun_p.initNode("drive-red", 0, "BOOL"),
		annun_p.initNode("drive-amber", 0, "BOOL"),
	],
	batt_front: [
		annun_p.initNode("batt-front-red", 0, "BOOL"),
		annun_p.initNode("batt-front-amber", 0, "BOOL"),
	],
	batt_rear: [
		annun_p.initNode("batt-rear-red", 0, "BOOL"),
		annun_p.initNode("batt-rear-amber", 0, "BOOL"),
	],
	system_isol_fail:	annun_p.initNode("system-insulation-fail", 0, "BOOL"),
};
var selftest = annun_p.initNode("selftest", 0, "BOOL");

var time = props.globals.getNode("/sim/time/elapsed-sec", 1);

var charge_front = props.globals.getNode("/systems/electrical/battery-charge-percent-front", 1);
var charge_rear = props.globals.getNode("/systems/electrical/battery-charge-percent-back", 1);
var batt_front_offline = 0;
var batt_rear_offline = 0;
var power_controller_temp = props.globals.getNode("/engines/engine[0]/power-controller-temp-degc");
var engine_temp = props.globals.getNode("/engines/engine[0]/engine-temp-degc");
var eng_coolant_pump_serv = props.globals.getNode("/systems/cooling/engine-coolant-pump-serviceable", 1);
var batt_coolant_pump_serv = [
	props.globals.getNode("/systems/cooling/battery-coolant-pump-serviceable[0]", 1),
	props.globals.getNode("/systems/cooling/battery-coolant-pump-serviceable[1]", 1),
];
var system_isol_serv = props.globals.getNode("/systems/electrical/components/system-isolation-serviceable", 1);
var dcdc_comm_serv = props.globals.getNode("/systems/electrical/components/dcdc-communication-serviceable", 1);
var dcdc_serv = props.globals.getNode("/systems/electrical/components/dcdc-serviceable", 1);


var engine_rpm = props.globals.getNode("/engines/engine[0]/rpm", 1);

#	Load Limits
var limits = {
	motor: [
		getprop("/limits/powertrain/motor-temp-degc/caution"),
		getprop("/limits/powertrain/motor-temp-degc/warning"),
	],
	power_controller: [
		getprop("/limits/powertrain/power-controller-temp-degc/caution"),
		getprop("/limits/powertrain/power-controller-temp-degc/warning"),
	],
	battery: [
		getprop("/limits/powertrain/battery-temp-degc/caution"),
		getprop("/limits/powertrain/battery-temp-degc/warning"),
	],
};

var volts = props.globals.getNode("/systems/electrical/lv-volts", 1);
		 

var epsi_message = {
	new: func( prio, message, light = nil ) {
		var obj = {parents:[epsi_message]};
		obj.priority = prio;		# 0 = warning, 1 = caution
		obj.message = message;		# message text
		obj.light = light;		# associated annunciator panel light
		obj.event_time = time.getDoubleValue();	# save the time the message was triggered, for sorting messages
		obj.ack = 0;			# message has been acknowledged
		return obj;
	},
};

var active_messages = [ [], [] ];	# first vector for warning messages, second for caution messages
var active_lights = {
	drive: 0,			# 0 = off, 1 = amber, 2 = red
	batt_front: 0,			# 0 = off, 1 = amber, 2 = red
	batt_rear: 0,			# 0 = off, 1 = amber, 2 = red
	system_isol_fail: 0,
};

var trigger = {
	new: func( condition, prio, message, light = nil ) {
		var obj = {parents:[trigger]};
		obj.condition = condition;
		obj.priority = prio;
		obj.message = message;
		obj.light = light;
		obj.active_msg = nil;
		return obj;
	},
	update: func() {
		if( me.condition() and me.active_msg == nil ){
			me.active_msg = epsi_message.new( me.priority, me.message, me.light );
		} elsif( !me.condition() and me.active_msg != nil and me.active_msg.ack ){
			me.active_msg = nil;
		}
	},
};
var trigger2 = {
	new: func( prio, message, light = nil ) {
		var obj = {parents:[trigger2]};
		obj.priority = prio;
		obj.message = message;
		obj.light = light;
		obj.active_msg = nil;
		return obj;
	},
	update: func() {},
	trigger: func( extra_text = "" ) {
		if( me.active_msg == nil ){
			me.active_msg = epsi_message.new( me.priority, me.message ~ extra_text, me.light );
		}
	},
	reset: func() {
		if( me.active_msg != nil and me.active_msg.ack ){
			me.active_msg = nil;
		}
	},
};

var triggers = [
	[
		trigger2.new( 0, "BATTERY F\nDISCONNECTED\nDUE TO:\n", "batt_front.2" ),
		trigger2.new( 0, "BATTERY R\nDISCONNECTED\nDUE TO:\n", "batt_rear.2" ),
		trigger.new( func return (power_controller_temp.getDoubleValue() > 70 or engine_temp.getDoubleValue() > 110), 0, "ENGINE\nOVERTEMP", "drive.2" ), # POH p.2-5
	],
	[
		trigger2.new( 1, "BATTERY F\nSTARTUP FAILED", "batt_front.1" ),
		trigger2.new( 1, "BATTERY R\nSTARTUP FAILED", "batt_front.1" ),
		trigger2.new( 1, "BATTERY F\nSELFTEST FAILED\n", "batt_front.1" ),
		trigger2.new( 1, "BATTERY R\nSELFTEST FAILED\n", "batt_rear.1" ),
		trigger.new( func return alphaelectro.batt.temp[0].getDoubleValue() > limits.battery[0], 1, "BATTERY F\nHIGH TEMPERATURE", "batt_front.1" ),
		trigger.new( func return alphaelectro.batt.temp[1].getDoubleValue() > limits.battery[0], 1, "BATTERY R\nHIGH TEMPERATURE", "batt_rear.1" ),
		trigger.new( func return alphaelectro.batt.temp[0].getDoubleValue() > limits.battery[1]-2, 1, "BATTERY F\nABOUT TO\nDISCONNECT", "batt_front.1" ),
		trigger.new( func return alphaelectro.batt.temp[1].getDoubleValue() > limits.battery[1]-2, 1, "BATTERY R\nABOUT TO\nDISCONNECT", "batt_rear.1" ),
		trigger.new( func return batt_front_offline, 1, "BATTERY F\nNOT PRESENT", "batt_front.1" ),
		trigger.new( func return batt_rear_offline, 1, "BATTERY R\nNOT PRESENT", "batt_rear.1" ),
		trigger.new( func return ( ( batt_front_offline and !batt_rear_offline ) or ( !batt_front_offline and batt_rear_offline ) ) and engine_rpm.getDoubleValue() > 300 , 1, "ONLY ONE\nBATTERY PACK\nIS ACTIVE" ), # and power controller ON
		trigger.new( func return ( ( ( charge_front.getDoubleValue() + charge_rear.getDoubleValue() ) / 2 ) < 0.3 ), 1, "SOC <30%", "batt_both.1"),
		trigger.new( func return ( ( ( charge_front.getDoubleValue() + charge_rear.getDoubleValue() ) / 2 ) < 0.15 ), 1, "NO GO-AROUND\nAVAILABLE"),
		trigger.new( func return ( power_controller_temp.getDoubleValue() > limits.power_controller[0] and power_controller_temp.getDoubleValue() < limits.power_controller[1] ) or ( engine_temp.getDoubleValue() >  limits.motor[0] and engine_temp.getDoubleValue() <  limits.motor[1] ), 1, "ENGINE HIGH\nTEMPERATURE" ),
		trigger.new( func return ( !eng_coolant_pump_serv.getBoolValue() ), 1, "ENGINE COOLANT\nPUMP FAILURE", "drive.1" ),
		trigger.new( func return ( !batt_coolant_pump_serv[0].getBoolValue() ), 1, "BATTERY COOLANT\nPUMP 1 FAILURE"),
		trigger.new( func return ( !batt_coolant_pump_serv[1].getBoolValue() ), 1, "BATTERY COOLANT\nPUMP 2 FAILURE"),
		trigger.new( func return ( !system_isol_serv.getBoolValue() ), 1, "SYSTEM\nISOLATION\nFAILURE", "system_isol_fail" ),
		trigger.new( func return ( !dcdc_comm_serv.getBoolValue() ), 1, "DC/DC\nCOMMUNICATION\nFAILURE" ),
		trigger.new( func return ( !dcdc_serv.getBoolValue() and dcdc_comm_serv.getBoolValue() ), 1, "DC/DC\nNOT WORKING"),
		trigger.new( func return ( !alphaelectro.power_lever_comm_serv.getBoolValue() ), 1, "POWER LEVER\nCOMMUNICATION\nFAILURE" ),
		trigger.new( func return ( !alphaelectro.aux_batt_serv.getBoolValue() ), 1, "AUXILIARY\nBATTERY\nFAILURE" ),
		trigger.new( func return ( !alphaelectro.batt_fan_serv.getBoolValue() ), 1, "BATTERY COOLANT\nFAN FAILURE" ),
		trigger.new( func return ( math.abs( alphaelectro.battery_front.volts.getDoubleValue() - alphaelectro.battery_rear.volts.getDoubleValue() ) > 5 ), 1, "BATTERY VOLTAGES\nNOT EQUAL" ),
		trigger.new( func return ( math.abs( alphaelectro.battery_front.amps.getDoubleValue() - alphaelectro.battery_rear.amps.getDoubleValue() ) > 5 ), 1, "BATTERY CURRENT\nNOT EQUAL" ),	# TODO current diff limit?
		
		#	TODO
		#		BATTERY F/R OVERCURRENT
		#		BATTERY F/R STARTUP FAILED
		#		BATTERY F/R SOC ADJUSTED
		#		BATTERY F/R LOW CELL VOLTAGE
		#		BATTERY F/R SELFTEST FAILED PBIT
		#		BATTERY F/R SELFTEST FAILED LOW TEMP (< 0 degc)
		#		ENGINE COMMUNICATION FAILURE
	],
];

var master_caution_message = nil;
var master_warning_message = nil;
var last_selftest = -1;

var main_loop = func{
	if( volts.getDoubleValue() < 9 ) return;
	
	foreach( var el; triggers ){
		foreach( var em; el ){
			em.update();
		}
	}
	# Gather all active messages, then sort them
	active_messages = [ [], [] ];
	active_lights = {
		drive: 0,			# 0 = off, 1 = amber, 2 = red
		batt_front: 0,			# 0 = off, 1 = amber, 2 = red
		batt_rear: 0,			# 0 = off, 1 = amber, 2 = red
		system_isol_fail: 0,
	};
	forindex( var i; triggers ){
		foreach( var el; triggers[i] ){
			if( el.active_msg != nil ){
				append( active_messages[i], el.active_msg );
				if( el.active_msg.light != nil){
					if( el.active_msg.light == "system_isol_fail" ){
						active_lights.system_isol_fail = 1;
					} else {
						var cat = split( ".", el.active_msg.light )[0];
						var val = split( ".", el.active_msg.light )[1];
						if( cat == "batt_both" ){
							if( val > active_lights.batt_front ){
								active_lights.batt_front = val;
							}
							if( val > active_lights.batt_rear ){
								active_lights.batt_rear = val;
							}
						} else {
							if( val > active_lights[cat] ){
								active_lights[cat] = val;
							}
						}
					}
				}
			}
		}
	}
	
	foreach( var key; keys(active_lights) ){
		if( active_lights[key] > 0 ){
			if( active_lights[key] == 2 ){
				annun_lights[key][0].setBoolValue(1);
				annun_lights[key][1].setBoolValue(0);
			} elsif( active_lights[key] == 1 ){ 
				if( isvec( annun_lights[key] ) ){
					annun_lights[key][0].setBoolValue(0);
					annun_lights[key][1].setBoolValue(1);
				} else {
					annun_lights[key].setBoolValue(1);
				}
			}
		} else {
			if( isvec( annun_lights[key] ) ){
				annun_lights[key][0].setBoolValue(0);
				annun_lights[key][1].setBoolValue(0);
			} else {
				annun_lights[key].setBoolValue(0);
			}
		}
	}
			
	
	# Sort:
	var sorted = 0;
	forindex( var x; active_messages ){
		sorted = 0;
		while( !sorted ){
			sorted = 1;
			var i = 0;
			while( i < size(active_messages[x])-1 ){
				if( active_messages[x][i].priority > active_messages[x][i + 1].priority ){
					var temp = active_messages[x][i];
					active_messages[x][i] = active_messages[x][i+1];
					active_messages[x][i+1]=temp;
					sorted = 0;
				} elsif( active_messages[x][i].event_time < active_messages[x][i+1].event_time ){
					var temp = active_messages[x][i];
					active_messages[x][i] = active_messages[x][i+1];
					active_messages[x][i+1]=temp;
					sorted = 0;
				}
				i += 1;
			}
		}
	}
	
	# The most important message (most recent and highest priority) is shown on the annunciator panel:
	master_warning_message = nil;
	master_caution_message = nil;
	var message_found = 0;
	if( size( active_messages[0] ) > 0 and active_messages[0][0] != nil ){
		var i = 0;
		while( i < size(active_messages[0]) and !message_found ){
			if( !active_messages[0][i].ack ){
				master_warning_message = active_messages[0][i];
				annun_lights.master_warning.setBoolValue( 1 );
				annun_lights.master_caution.setBoolValue( 0 );
				message_found = 1;
			} else {
				i += 1;
			}
		}
		if( !message_found ){
			annun_lights.master_warning.setBoolValue( 0 );
		}
	} else {
		annun_lights.master_warning.setBoolValue( 0 );
	}
	if( size( active_messages[1] ) > 0 and !message_found ){
		var i = 0;
		while( i < size(active_messages[1]) and !message_found ){
			if( !active_messages[1][i].ack ){
				master_caution_message = active_messages[1][i];
				annun_lights.master_caution.setBoolValue( 1 );
				message_found = 1;
			} else {
				i += 1;
			}
		}
		if( !message_found ){
			annun_lights.master_caution.setBoolValue( 0 );
		}
	} else {
		annun_lights.master_caution.setBoolValue( 0 );
	}
	
	if( selftest.getBoolValue() and last_selftest != 1 ){
		annun_lights.master_caution.setBoolValue( 1 );
		annun_lights.master_warning.setBoolValue( 1 );
		annun_lights.drive[0].setBoolValue( 1 );
		annun_lights.drive[1].setBoolValue( 1 );
		annun_lights.batt_front[0].setBoolValue( 1 );
		annun_lights.batt_front[1].setBoolValue( 1 );
		annun_lights.batt_rear[0].setBoolValue( 1 );
		annun_lights.batt_rear[1].setBoolValue( 1 );
		annun_lights.system_isol_fail.setBoolValue( 1 );
		last_selftest = 1;
	} elsif( !selftest.getBoolValue() and last_selftest != 0 ){
		annun_lights.master_caution.setBoolValue( 0 );
		annun_lights.master_warning.setBoolValue( 0 );
		annun_lights.drive[0].setBoolValue( 0 );
		annun_lights.drive[1].setBoolValue( 0 );
		annun_lights.batt_front[0].setBoolValue( 0 );
		annun_lights.batt_front[1].setBoolValue( 0 );
		annun_lights.batt_rear[0].setBoolValue( 0 );
		annun_lights.batt_rear[1].setBoolValue( 0 );
		annun_lights.system_isol_fail.setBoolValue( 0 );
		last_selftest = 0;
	}
		
	
	# EPSI570 Driver
	var message_lines = [];
	var i = 0;
	while( i <= 6 and i < size( active_messages[0] ) ){
		append( message_lines, [ active_messages[0][i].priority, active_messages[0][i].message, active_messages[0][i].ack ] );
		i += 1;
	}
	var lines_left = 6 - i;
	i = 0;
	while( i <= lines_left and i < size( active_messages[1] ) ){
		append( message_lines, [ active_messages[1][i].priority, active_messages[1][i].message, active_messages[1][i].ack ] );
		i += 1;
	}
	
	canvas_epsi570.message_lines = message_lines;
	
}

var master_caution_btn = func {
	if( master_caution_message != nil ){
		master_caution_message.ack = 1;
	}
}

var master_warning_btn = func {
	if( master_warning_message != nil ){
		master_warning_message.ack = 1;
	}
}

var epsi_ack = func {
	if( master_caution_message != nil ){
		master_caution_message.ack = 1;
	}
	if( master_warning_message != nil ){
		master_warning_message.ack = 1;
	}
}

var last_master_switch = -1;
setlistener( "controls/switches/master-bat", func( v ){
	if( v.getBoolValue() and last_master_switch != 1 ){
		selftest.setBoolValue( 1 );
		settimer( func{ selftest.setBoolValue( 0 ) }, 1.5 );
	} elsif( !v.getBoolValue() and last_master_switch != 0 ){
		selftest.setBoolValue( 0 );
	}
});

var main_loop_timer = maketimer( 1, main_loop );
main_loop_timer.simulatedTime = 1;

var fl = setlistener("/sim/signals/fdm-initialized", func{
	main_loop_timer.start();
	removelistener( fl );
});
