#################################################################################
#		Lake of Constance Hangar												                            #
#	  RR-ACCEL for Flightgear												                              #
#		Copyright (C) 2022 M.Kraus												                          #
#																				                                        #
#		This program is free software: you can redistribute it and/or modify	      #
#		it under the terms of the GNU General Public License as published by	      #
#		the Free Software Foundation, either version 3 of the License, or		        #
#		(at your option) any later version.										                      #
#																				                                        #
#		This program is distributed in the hope that it will be useful,			        #
#		but WITHOUT ANY WARRANTY; without even the implied warranty of			        #
#		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			          #
#		GNU General Public License for more details.							                  #
#																				                                        #
#		You should have received a copy of the GNU General Public License		        #
#		along with this program.  If not, see <http://www.gnu.org/licenses/>.	      #
#																				                                        #
#		Every software has a developer, also free software. 					              #
#		As a gesture of courtesy and respect, I would be delighted 				          #
#		if you contacted me before making any changes to this software. 		        #
#		<info (at) marc-kraus.de> Dec, 2021									                        #
#################################################################################

# Das Aufladen erfolgt einfach über das Anlegen einer höheren Spannung auf den bus, als sie in engine-volts anliegt.

var fbs_electrical_loop = nil;
var last_time = nil;

# Properties

var property_base	= props.globals.getNode("/systems/accel-electrical/", 1);
var electrical_base	= property_base.initNode("battery");

var start		= property_base.initNode("start", 0, "BOOL");				#	0 : switched off; 0-1 : starting up; 1: running
var start12v		= property_base.initNode("start12v", 0, "BOOL");		#	0 : switched off; 0-1 : starting up; 1: running
var startsystems		= property_base.initNode("startsys", 0,"DOUBLE"); 	#create the system start procedere
var bus_volts		= property_base.initNode("outputs/bus", 0,"DOUBLE"); 	#Current supplied by the aircraft's avionics bus
var cabin_dim		= property_base.initNode("outputs/cabin-dim", 0,"DOUBLE"); # internal lights
var cabin_dim_pos	= property_base.initNode("outputs/cabin-dim-pos", 0,"DOUBLE"); # internal lights

var inst_output_prop_rot = property_base.initNode("fake-outputs/proppeller-rotation", 0,"DOUBLE"); 	# unfortunately I can't do it better due to lack of skills
var inst_output_eng_rpm = property_base.initNode("fake-outputs/engine-rpm", 0,"DOUBLE"); 	# unfortunately I can't do it better due to lack of skills
var inst_output_hp = property_base.initNode("fake-outputs/hp", 0,"DOUBLE"); 	# unfortunately I can't do it better due to lack of skills
var inst_output_kw = property_base.initNode("fake-outputs/kw", 0,"DOUBLE"); 	# unfortunately I can't do it better due to lack of skills


var cb0		= property_base.initNode("circuit-breakers/cb[0]", 1,"BOOL"); # switchpanel
var cb1		= property_base.initNode("circuit-breakers/cb[1]", 1,"BOOL"); # switchpanel
var cb2		= property_base.initNode("circuit-breakers/cb[2]", 1,"BOOL"); # switchpanel
var cb3		= property_base.initNode("circuit-breakers/cb[3]", 1,"BOOL"); # switchpanel
var cb4		= property_base.initNode("circuit-breakers/cb[4]", 1,"BOOL"); # switchpanel
var cb5		= property_base.initNode("circuit-breakers/cb[5]", 1,"BOOL"); # switchpanel
var cb6		= property_base.initNode("circuit-breakers/cb[6]", 1,"BOOL"); # switchpanel
var cb7		= property_base.initNode("circuit-breakers/cb[7]", 1,"BOOL"); # switchpanel
var cb8		= property_base.initNode("circuit-breakers/cb[8]", 1,"BOOL"); # switchpanel
var cb9		= property_base.initNode("circuit-breakers/cb[9]", 1,"BOOL"); # switchpanel
var cb10	= property_base.initNode("circuit-breakers/cb[10]", 1,"BOOL"); # switchpanel
var b0		= property_base.initNode("buttons/b[0]", 0,"BOOL"); # switchpanel
var b1		= property_base.initNode("buttons/b[1]", 0,"BOOL"); # switchpanel
var b2		= property_base.initNode("buttons/b[2]", 0,"BOOL"); # switchpanel
var b3		= property_base.initNode("buttons/b[3]", 0,"BOOL"); # switchpanel
var b4		= property_base.initNode("buttons/b[4]", 0,"BOOL"); # switchpanel
var b5		= property_base.initNode("buttons/b[5]", 0,"BOOL"); # switchpanel
var b6		= property_base.initNode("buttons/b[6]", 0,"BOOL"); # switchpanel
var b7		= property_base.initNode("buttons/b[7]", 0,"BOOL"); # switchpanel
var b8		= property_base.initNode("buttons/b[8]", 0,"BOOL"); # switchpanel
var b9		= property_base.initNode("buttons/b[9]", 0,"BOOL"); # switchpanel

# needed for the multiple chargements on the DDU10 instrument
var rand1 = 0.0;
var rand2 = 0.0;
var rand3 = 0.0;
var rand4 = 0.0;
var rand5 = 0.0;
var rand6 = 0.0;

while (rand1 < 0.5 or rand1 > 0.6) {
		rand1 = rand();
}
while (rand2 < 0.5 or rand2 > 0.6) {
		rand2 = rand();
}
while (rand3 < 0.5 or rand3 > 0.6) {
		rand3 = rand();
}
while (rand4 < 0.3 or rand4 > 0.7) {
		rand4 = rand();
}
while (rand5 < 0.3 or rand5 > 0.7) {
		rand5 = rand();
}
var pluscalcfact = (3-(rand1 + rand2 + rand3))/3;
var pluscalcfactfine = (2-(rand4 + rand5))/2;


var ins_volts		= electrical_base.initNode("engine-volts", 0.0, "DOUBLE");		#	voltage fed to the engine
var charge		= electrical_base.initNode("battery-charge-percent", 1.0, "DOUBLE");	#	internal battery charge
var c1 = electrical_base.initNode("cell[0]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c2 = electrical_base.initNode("cell[1]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c3 = electrical_base.initNode("cell[2]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c1p1 = electrical_base.initNode("cell[0]/pack[0]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c2p1 = electrical_base.initNode("cell[1]/pack[0]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c3p1 = electrical_base.initNode("cell[2]/pack[0]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c1p2 = electrical_base.initNode("cell[0]/pack[1]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c2p2 = electrical_base.initNode("cell[1]/pack[1]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c3p2 = electrical_base.initNode("cell[2]/pack[1]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c1p3 = electrical_base.initNode("cell[0]/pack[2]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c2p3 = electrical_base.initNode("cell[1]/pack[2]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c3p3 = electrical_base.initNode("cell[2]/pack[2]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c1p1f1 = electrical_base.initNode("cell[0]/pack[0]/fill[0]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c1p1f2 = electrical_base.initNode("cell[0]/pack[0]/fill[1]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c1p2f1 = electrical_base.initNode("cell[0]/pack[1]/fill[0]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c1p2f2 = electrical_base.initNode("cell[0]/pack[1]/fill[1]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c1p3f1 = electrical_base.initNode("cell[0]/pack[2]/fill[0]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c1p3f2 = electrical_base.initNode("cell[0]/pack[2]/fill[1]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c2p1f1 = electrical_base.initNode("cell[1]/pack[0]/fill[0]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c2p1f2 = electrical_base.initNode("cell[1]/pack[0]/fill[1]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c2p2f1 = electrical_base.initNode("cell[1]/pack[1]/fill[0]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c2p2f2 = electrical_base.initNode("cell[1]/pack[1]/fill[1]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c2p3f1 = electrical_base.initNode("cell[1]/pack[2]/fill[0]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c2p3f2 = electrical_base.initNode("cell[1]/pack[2]/fill[1]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c3p1f1 = electrical_base.initNode("cell[2]/pack[0]/fill[0]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c3p1f2 = electrical_base.initNode("cell[2]/pack[0]/fill[1]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c3p2f1 = electrical_base.initNode("cell[2]/pack[1]/fill[0]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c3p2f2 = electrical_base.initNode("cell[2]/pack[1]/fill[1]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c3p3f1 = electrical_base.initNode("cell[2]/pack[2]/fill[0]/charge", 1.0, "DOUBLE");	#	internal battery charge
var c3p3f2 = electrical_base.initNode("cell[2]/pack[2]/fill[1]/charge", 1.0, "DOUBLE");	#	internal battery charge

var load		= electrical_base.initNode("load", 0.0, "DOUBLE");			#	internal battery load
var calculated_rest_time = electrical_base.initNode("crt", 1.0, "DOUBLE");			#	how long stay the battery
var calculated_rest_hours = electrical_base.initNode("crh", 0, "INT");			#	how long stay the battery
var calculated_rest_min = electrical_base.initNode("crm", 0, "INT");			#	how long stay the battery
var calculated_rest_sec = electrical_base.initNode("crs", 0, "INT");			#	how long stay the battery
var bus_load		= electrical_base.initNode("bus-load", 0.0, "DOUBLE");			#	Load on the avionics bus (from this engine)
var ffb			= electrical_base.initNode("feed-from-battery", 0, "BOOL");		#	0: fed from avionics bus 1: fed from internal battery
var eng_limit		= electrical_base.initNode("engine-limit", 0.0, "DOUBLE");		#	main param for power
var eng_lospower	= electrical_base.initNode("engine-loses-power", 0.0, "DOUBLE");		#	factor for los power give his values in jsbsim to fcs/throttle-pos-norm and fcs/throttle-cmd-norm
var bc			= electrical_base.initNode("battery-charging", 0, "BOOL");		#	0: not charging 1: charging

var cover_emer1	   = props.globals.initNode("/controls/switches/emergency/cover[0]",1,"BOOL");
var cover_emer2	   = props.globals.initNode("/controls/switches/emergency/cover[1]",1,"BOOL");
var cover_emer3	   = props.globals.initNode("/controls/switches/emergency/cover[2]",1,"BOOL");

var emer1	   = props.globals.initNode("/controls/switches/emergency/switch[0]",1,"BOOL");
var emer2	   = props.globals.initNode("/controls/switches/emergency/switch[1]",1,"BOOL");
var emer3	   = props.globals.initNode("/controls/switches/emergency/switch[2]",1,"BOOL");

var mtp_low = props.globals.initNode("/controls/mtp/low",1,"BOOL");
var mtp_manu = props.globals.initNode("/controls/mtp/manu",0,"BOOL");
var mtp_rpm = props.globals.initNode("/controls/mtp/rpm",1400.0,"DOUBLE");
props.globals.initNode("/systems/accel-electrical/battery/drag-factor",1,"BOOL");

# only for the two lean instruments from the Instruments-3d folder
setprop("/systems/electrical/outputs/comm[0]",0);
setprop("/systems/electrical/outputs/transponder",0);


var throttle = props.globals.getNode("/controls/engines/engine[0]/throttle", 1);
var engine_rpm = props.globals.getNode("/engines/engine/rpm", 1);
var power_hp = props.globals.getNode("/fdm/jsbsim/propulsion/engine/power-hp", 1);
var prop_rpm = props.globals.getNode("/fdm/jsbsim/propulsion/engine/propeller-rpm",1);
var blade_angle_pos = props.globals.initNode("/fdm/jsbsim/propulsion/engine/blade-angle-pos",0.0,"DOUBLE");


var elapsed_sec = props.globals.getNode("/sim/time/elapsed-sec",	1);
var replay_state	= props.globals.getNode("/sim/freeze/replay-state",	1);
var last_time	= props.globals.getNode("/sim/time/steady-clock-sec",	1);

var BatteryClass = {
		new : func {
			var obj = {
				parents : [BatteryClass],
				ideal_volts : 750.0,
				ideal_amps : 1000.0,
				amp_hours : 288.0,
				charge_percent : 1.0,
				charge_amps : 0.88,			# acid battery 0.56 / Lithium ion battery 0.8 - 0.9
				};
			charge.setValue(obj.charge_percent);
			return obj;
		},
		apply_load : func (amps, dt) {
			load.setValue(amps);
			var old_charge_percent = charge.getValue();

			if(amps > 0.0){
				calculated_rest_time.setValue(me.amp_hours*old_charge_percent/amps);
				var s = calculated_rest_time.getValue()*3600;
				calculated_rest_hours.setValue(int(s / 3600));
				calculated_rest_min.setValue(int(math.mod(s / 60, 60)));
				calculated_rest_sec.setValue(int(math.mod(s, 60)));
			}

			if ( replay_state.getBoolValue() )
				return me.amp_hours * old_charge_percent;

			var amphrs_used = amps * dt / 3600.0;
			var percent_used = amphrs_used / me.amp_hours;

			var new_charge_percent = std.max(0.0, std.min(old_charge_percent - percent_used, 1.0));

			me.charge_percent = new_charge_percent;
			charge.setValue(new_charge_percent);

			# fake calculation for the multiple chargements of every cell displayed in the DDU10 instrument
			c1.setValue(charge.getValue()*(rand1+pluscalcfact));
			c2.setValue(charge.getValue()*(rand2+pluscalcfact));
			c3.setValue(charge.getValue()*(rand3+pluscalcfact));

			c1p1.setValue(c1.getValue()*(rand1+pluscalcfact));
			c2p1.setValue(c2.getValue()*(rand3+pluscalcfact));
			c3p1.setValue(c3.getValue()*(rand2+pluscalcfact));
			c1p2.setValue(c1.getValue()*(rand3+pluscalcfact));
			c2p2.setValue(c2.getValue()*(rand2+pluscalcfact));
			c3p2.setValue(c3.getValue()*(rand1+pluscalcfact));
			c1p3.setValue(c1.getValue()*(rand2+pluscalcfact));
			c2p3.setValue(c2.getValue()*(rand1+pluscalcfact));
			c3p3.setValue(c3.getValue()*(rand3+pluscalcfact));

			c1p1f1.setValue(1-((1-c1p1.getValue())*(rand4+pluscalcfactfine)));
			c1p1f2.setValue(1-((1-c1p1.getValue())*(rand5+pluscalcfactfine)));
			c1p2f1.setValue(1-((1-c1p2.getValue())*(rand5+pluscalcfactfine)));
			c1p2f2.setValue(1-((1-c1p2.getValue())*(rand4+pluscalcfactfine)));
			c1p3f1.setValue(1-((1-c1p3.getValue())*(rand5+pluscalcfactfine)));
			c1p3f2.setValue(1-((1-c1p3.getValue())*(rand4+pluscalcfactfine)));
			c2p1f1.setValue(1-((1-c2p1.getValue())*(rand4+pluscalcfactfine)));
			c2p1f2.setValue(1-((1-c2p1.getValue())*(rand5+pluscalcfactfine)));
			c2p2f1.setValue(1-((1-c2p2.getValue())*(rand5+pluscalcfactfine)));
			c2p2f2.setValue(1-((1-c2p2.getValue())*(rand4+pluscalcfactfine)));
			c2p3f1.setValue(1-((1-c2p3.getValue())*(rand5+pluscalcfactfine)));
			c2p3f2.setValue(1-((1-c2p3.getValue())*(rand4+pluscalcfactfine)));
			c3p1f1.setValue(1-((1-c3p1.getValue())*(rand4+pluscalcfactfine)));
			c3p1f2.setValue(1-((1-c3p1.getValue())*(rand5+pluscalcfactfine)));
			c3p2f1.setValue(1-((1-c3p2.getValue())*(rand5+pluscalcfactfine)));
			c3p2f2.setValue(1-((1-c3p2.getValue())*(rand4+pluscalcfactfine)));
			c3p3f1.setValue(1-((1-c3p3.getValue())*(rand5+pluscalcfactfine)));
			c3p3f2.setValue(1-((1-c3p3.getValue())*(rand4+pluscalcfactfine)));

			# last line from apply_load
			return me.amp_hours * new_charge_percent;

		},
		get_output_volts : func {
			var x = 1.0 - me.charge_percent;
			var tmp = -(3.0 * x - 1.0);
			var factor = (math.pow(tmp, 5) + 32) / 32;
			return me.ideal_volts * factor;
		},
		get_output_amps : func {
			var x = 1.0 - me.charge_percent;
			var tmp = -(3.0 * x - 1.0);
			var factor = (math.pow(tmp, 5) + 32) / 32;
			return me.ideal_amps * factor;
		},
		reset_to_full_charge : func {
			me.apply_load(-(1.0 - me.charge_percent) * me.amp_hours, 3600);
		},
	};



var internal_battery = BatteryClass.new();


var update_electrical = func () {
	var time = elapsed_sec.getDoubleValue();
	var dt = time - last_time;
	last_time = time;

	#print( "last_time = ", last_time );
	#print("dt = ", dt);

	var start_v = start.getBoolValue();
	var start12v_v = start12v.getBoolValue();
	var bus_volts_v = bus_volts.getValue();
	var startsys_state = startsystems.getValue();
	var battery_volts = internal_battery.get_output_volts();
	var charge_v = charge.getValue();
	var throttle_v = throttle.getValue();

	var engine_consumption = 0.0;

	####### this lines to feed the Instruments-3d
	if( start12v_v){
		if(startsys_state <= 0){interpolate("/systems/accel-electrical/startsys",1,6);}
		setprop("/systems/electrical/outputs/comm[0]",28);
		setprop("/systems/electrical/outputs/transponder",28);
		cabin_dim.setDoubleValue(cabin_dim_pos.getValue());

	}else{
		setprop("/systems/electrical/outputs/comm[0]",0);
		setprop("/systems/electrical/outputs/transponder",0);
		cabin_dim.setDoubleValue(0.0);
		startsystems.setDoubleValue(0.0);
	}

	####### controll the emergency switch covers for the three electrical engine_consumption        ### Emergency switches on Trimpanel

  var ce1 = cover_emer1.getValue();
  var ce2 = cover_emer2.getValue();
  var ce3 = cover_emer3.getValue();

  if(ce1 == 1){
    emer1.setBoolValue(1);
  }
  if(ce2 == 1){
    emer2.setBoolValue(1);
  }
  if(ce3 == 1){
    emer3.setBoolValue(1);
  }

  #### listen to propeller pitch setting in the mt-propeller instrument - do not change anything in the thrust, only in view and sound
  var mtrpm = getprop("/controls/mtp/rpm");   #range from 1400 to 2400 / Propeller pitch from 2 to 85 degree
  var mtba = 85-((mtrpm - 1400) * 0.083);
	var manpower = 1;
  blade_angle_pos.setDoubleValue(mtba);
	if(mtp_manu.getBoolValue()){
		manpower = ((mtrpm - 1400)*0.0002)+0.8;
		if(manpower > 1){ manpower = 1 };
	};

	var iopr = 0;
	var ioer = 0;
	var iohp = 0;
	var iokw = 0;

	var powerfactor = (emer1.getBoolValue() + emer2.getBoolValue() + emer3.getBoolValue()) / 3;

	if( start_v == 1){
		setprop("/systems/accel-electrical/battery/drag-factor", 0);

		var is_eng_limit = eng_limit.getDoubleValue();
		var corr_eng_limit = is_eng_limit*powerfactor*manpower;

		var min_volts = internal_battery.ideal_volts - 50;

		if(ins_volts.getValue() < min_volts){
			# correction for the los of performance
			var corr_eng_limit = is_eng_limit*ins_volts.getValue()/min_volts*powerfactor*manpower;
		}
		eng_lospower.setDoubleValue(corr_eng_limit);

		# average is 450kW, max 750kW | 0.7456 hp to kw | * 1000 to get Watt not the kw after ht to kw
		engine_consumption = power_hp.getValue() * 0.7457 * 1000;

		# fake consumption correction
		if(engine_consumption > 3000000){
				engine_consumption = 1500000;
				iopr = prop_rpm.getValue()*0.9*powerfactor*manpower;
				ioer = engine_rpm.getValue()*0.9*powerfactor*manpower;
				if(prop_rpm.getValue()>2400){iopr = 2429*powerfactor*manpower};
				if(engine_rpm.getValue()>2450){ioer = 2430*powerfactor*manpower};
				if(power_hp.getValue()>1100){iohp = 1005*powerfactor*manpower};
				iokw = iohp * 0.7457;
		}elsif(engine_consumption > 760000){
			engine_consumption = 900000;
			iopr = prop_rpm.getValue()*0.9*powerfactor*manpower;
			ioer = engine_rpm.getValue()*0.9*powerfactor*manpower;
			if(prop_rpm.getValue()>2300){iopr = 2407*powerfactor*manpower};
			if(engine_rpm.getValue()>2320){ioer = 2408*powerfactor*manpower};
			if(power_hp.getValue()>1100){iohp = 950*powerfactor*manpower};
			iokw = iohp * 0.7457;
		}else{
			iopr = prop_rpm.getValue()*powerfactor*manpower;
			ioer = engine_rpm.getValue()*powerfactor*manpower;
			iohp = power_hp.getValue()*0.8*powerfactor*manpower;
			iokw = iohp * 0.7457;
		}

		inst_output_prop_rot.setDoubleValue(iopr);
		inst_output_eng_rpm.setDoubleValue(ioer);
		inst_output_hp.setDoubleValue(iohp);
		inst_output_kw.setDoubleValue(iokw);


		if( bus_volts_v > battery_volts ){						# The engine electrical system is fed from the avionics bus
			if ( charge_v < 1.0 ){
				internal_battery.apply_load(-internal_battery.charge_amps, dt);
				bc.setValue(1);
				bus_load.setValue(internal_battery.charge_amps*bus_volts_v + engine_consumption);
			}else{
				bus_load.setValue(engine_consumption);
				bc.setValue(0);
			}
			ins_volts.setValue(bus_volts_v);
			ffb.setValue(0);
		} else {									# The engine electrical system is fed from its internal battery
			ins_volts.setValue(battery_volts*powerfactor*manpower);
			ffb.setValue(1);
			bc.setValue(0);
			if ( battery_volts > 0 ){
				internal_battery.apply_load(engine_consumption*manpower/battery_volts, dt);
			}
		}

	}else{
		# main power switch off
		setprop("/systems/accel-electrical/battery/engine-limit", 0);
		setprop("/systems/accel-electrical/battery/engine-loses-power", 0);
		setprop("/systems/accel-electrical/battery/engine-volts", 0);
		setprop("/systems/accel-electrical/battery/drag-factor", 1);
		setprop("/controls/mtp/rpm",1400);
	}
}

# init at startup

var elec_ls = setlistener("/sim/signals/fdm-initialized", func {
	internal_battery.reset_to_full_charge();
	last_time = elapsed_sec.getDoubleValue();
	fbs_electrical_loop = maketimer(0.2, update_electrical);
	fbs_electrical_loop.simulatedTime = 1;
	fbs_electrical_loop.start();
	removelistener( elec_ls );
});

# func as helper

var switch_mtp_low = func {
	var state = getprop("/controls/mtp/low") or 0;
	if(state == 1){
		setprop("/controls/mtp/low", 0);
		interpolate("/systems/accel-electrical/battery/engine-limit",2.8,3);
	}else{
		setprop("/controls/mtp/low", 1);
		interpolate("/systems/accel-electrical/battery/engine-limit",1.3,3);
	}
}

var switch_mtp_manu = func {
	var state = getprop("/controls/mtp/manu") or 0;
	if(state == 1){
		setprop("/controls/mtp/manu", 0);
	}else{
		setprop("/controls/mtp/manu", 1);
		interpolate("/systems/accel-electrical/battery/engine-limit",1.3,3);
	}
}

var push_but_pace = func {
	var state = getprop("/systems/accel-electrical/buttons/b[5]") or 0;
	if(state == 1){
		setprop("/systems/accel-electrical/buttons/b[5]", 0);
		interpolate("/systems/accel-electrical/battery/engine-limit",1.3,3);
	}else{
		setprop("/systems/accel-electrical/buttons/b[5]", 1);
		interpolate("/systems/accel-electrical/battery/engine-limit",5,3);
	}
}

var switch_main_start = func {
	var state = getprop("/systems/accel-electrical/start") or 0;
	if(state == 1){
		setprop("/systems/accel-electrical/start", 0);
		setprop("/systems/accel-electrical/battery/engine-limit",0);
	}else{
		setprop("/controls/engines/engine[0]/throttle",0);
		setprop("/systems/accel-electrical/start", 1);
		setprop("/systems/accel-electrical/battery/engine-limit",1.3);
	}
}
