####################################
####	Pipistrel Taurus	####
####################################

##	Liveries	##
aircraft.livery.init("Aircraft/Taurus/Models/Liveries" );

##	Instruments	##
# Load vario instrument for the mechanical vario-5stv5
# (the following code is based on the ILEC SC7 e-vario)
io.include("Aircraft/Generic/soaring-instrumentation-sdk.nas");

var probe = TotalEnergyProbe.new();

var vario_needle = Dampener.new(
	input: probe,
	dampening: 2.7,
	on_update: update_prop("/instrumentation/variometer/te-reading-mps"));

# Wrap everything together into an instrument
var fast_instruments = UpdateLoop.new(
	update_period: 0,
	components: [probe, vario_needle],
	enable: 1);

##	Propeller Animation	##
var time_last	=	0.0;
var time_temp	=	0.0;
var pos_last	=	0.0;
var prop	=	0.0;
var time_p	=	nil;
var rpm_p	=	nil;
var prop_p	=	nil;
var returning	=	0;

var prop_animator = func () {
	time_temp = time_p.getDoubleValue();
	var dt = time_temp - time_last;
	time_last = time_temp;
	var rpm = rpm_p.getDoubleValue();
	if( rpm > 0.01 ){
		if( returning != 0 ){
			returning = 0;
		}
		prop = math.periodic( 0, 360, 6 * rpm * dt + prop);
		prop_p.setDoubleValue( prop );
	} else {
		if( returning != 1 ){
			if( pos_last > 0 ){
				interpolate( prop_p, 180.0, 1.0 );
				pos_last = 180.0;
			} else {
				interpolate( prop_p, 360.0, 1.0 );
				pos_last = 360.0;
			}
			returning = 1;
		}
	}
}

var prop_animator_update = maketimer( 0.0, prop_animator );

##	Listeners	##
var ls = setlistener("/sim/signals/fdm-initialized", func() {
	time_p	=	props.globals.getNode("/sim/time/elapsed-sec");
	rpm_p	=	props.globals.getNode("/engines/engine[0]/rpm");
	prop_p	=	props.globals.initNode("/engines/engine[0]/propeller-pos-deg", 0.0, "DOUBLE");
	
	prop_animator_update.start();
	
	removelistener( ls );
});
	
